

;=====================================================================================================================================================
;																									
;	( PIEL-04 )	 		GRAFICA LOGARIZMICA (DISTANCIA INTERSECCION TANGENTES A CENTRO TRAZA)									
;																									
;																									
;					** SPLINES-PLANAS ** ABIERTAS ** en PLANOS NO PARALELOS **											
;																									
;					PUNTEANDOLAS a Distancia= GRADUA-(MODU) => DIVIDE ==> ( LIS-PA ) y ( LIS-PB )								
;																									
;=====================================================================================================================================================



;=====================================================================================================================================================
;																									
;									*** ***  SUB-PROGRAMAS  *** ***											
;																									
;=====================================================================================================================================================


;-----------------------------------------------------------------------------------------------------------------------------------------------------
;	SPLINE-A   GRADUA	y DIVIDE => ( LIS-PA )  																	

	(DEFUN SPLI-A ( / )

		(SETQ SA00 (ENTSEL" MARCA --- SPLINE ABIERTA-3D --- SECCION-A ? ")) (TERPRI)
		(SETQ NA00  (CAR SA00)) 									; nombre Spline A 
		(SETQ ALIS  (ENTGET NA00))  									; lista Spline A
		(SETQ AELE  (ASSOC 10 ALIS))  								; 1 Punto Asociado a 10 (10.punto)
		(SETQ AELES (MEMBER AELE ALIS)) 								; lista a partir del Alterior (10.punto)....(11.punto)
		(SETQ A-primer (CDR (NTH 0 AELES))) 							; primer elemento (10.punto)
		(SETQ A-ultimo (CDR (NTH (- (LENGTH AELES) 1) AELES)))				; ultimo elemento (11.punto)
		(COMMAND "color" 1 "TEXTO" A-primer 0.2 0 "A")						; TEXTO = A
		(COMMAND "PUNTO" A-primer)									; PINTA 1 punto A
		(SETQ N-enti-A1 (ENTLAST))									; nombre ultima entidad principal 1 punto A
		(COMMAND "GRADUA" NA00 MODU)									; gradua SPLI-A
		(COMMAND "PUNTO" A-ultimo)									; PINTA Ultimo Punto A
	
		;	PUNTOS SECCION-A (PA1-PAn) =>   LIS-PA  Lon-LPA															
		(SETQ LIS-PA nil)											; LISTA  PUNTOS-A
		(SETQ LIS-PA (CONS (CDR (ASSOC 10 (ENTGET N-enti-A1))) LIS-PA))			; lista entidad -> (1 Punto-A)
		(SETQ W1A T)
		(WHILE W1A
			(SETQ N-enti-A2 (ENTNEXT N-enti-A1))						; Nombre entidad siguiente
			(COMMAND "BORRA" N-enti-A1 "")
			(IF (= N-enti-A2 nil)  (SETQ W1A nil)
				(PROGN
					(SETQ LIS-PA (CONS (CDR (ASSOC 10 (ENTGET N-enti-A2))) LIS-PA))
					(SETQ N-enti-A1  N-enti-A2 )
				);progn
			);if
		) ;While W1A
		;	LISTA ( LIS-PA )																				
		(SETQ LIS-PA  (REVERSE LIS-PA))
		(SETQ NPA (LENGTH LIS-PA))

		;	SPLINE-A   DIVIDE																				
		(SETQ ALIS  (ENTGET NA00))  									; lista Spline A
		(SETQ AELE  (ASSOC 10 ALIS))  								; 1 Punto Asociado a 10 (10.punto)
		(SETQ AELES (MEMBER AELE ALIS)) 								; lista a partir del Alterior (10.punto)....(11.punto)
		(SETQ A-primer (CDR (NTH 0 AELES))) 							; primer elemento (10.punto)
		(SETQ A-ultimo (CDR (NTH (- (LENGTH AELES) 1) AELES)))				; ultimo elemento (11.punto)
		(COMMAND "color" 1 "TEXTO" A-primer 0.2 0 "A")						; TEXTO = A
		(COMMAND "PUNTO" A-primer)									; PINTA 1 punto A
		(SETQ N-enti-A1 (ENTLAST))									; nombre ultima entidad principal 1 punto A
		(COMMAND "DIVIDE" NA00 (- NPA 1))								; DIVIDE SPLI-A
		(COMMAND "PUNTO" A-ultimo)									; PINTA Ultimo Punto A
	
		;	PUNTOS SECCION-A (PA1-PAn) =>   LIS-PA  Lon-LPA															
		(SETQ LIS-PA nil)											; LISTA  PUNTOS-A
		(SETQ LIS-PA (CONS (CDR (ASSOC 10 (ENTGET N-enti-A1))) LIS-PA))			; lista entidad -> (1 Punto-A)
		(SETQ W1A T)
		(WHILE W1A
			(SETQ N-enti-A2 (ENTNEXT N-enti-A1))						; Nombre entidad siguiente
			;(COMMAND "BORRA" N-enti-A1 "")
			(IF (= N-enti-A2 nil)  (SETQ W1A nil)
				(PROGN
					(SETQ LIS-PA (CONS (CDR (ASSOC 10 (ENTGET N-enti-A2))) LIS-PA))
					(SETQ N-enti-A1  N-enti-A2 )
				);progn
			);if
		) ;While W1A
		;	LISTA ( LIS-PA )																				
		(SETQ LIS-PA  (REVERSE LIS-PA))
		;  (LENGTH LIS-PA)

	) ; Defun SPLI-A

;																									
;-----------------------------------------------------------------------------------------------------------------------------------------------------


;-----------------------------------------------------------------------------------------------------------------------------------------------------
;	SPLINE-B   GRADUA	y DIVIDE => ( LIS-PB ) 																		

	(DEFUN SPLI-B ( / )

		(SETQ SB00 (ENTSEL" MARCA --- SPLINE ABIERTA 3D --- SECCION-B ? ")) (TERPRI) (TERPRI)
		(SETQ NB00  (CAR SB00)) 									; nombre Spline B 
		(SETQ BLIS  (ENTGET NB00))  									; lista Spline B 
		(SETQ BELE  (ASSOC 10 BLIS))  								; 1 Punto Asociado a 10 (10.punto)
		(SETQ BELES (MEMBER BELE BLIS)) 								; lista a partir del Alterior (10.punto)....(11.punto)
		(SETQ B-primer (CDR (NTH 0 BELES))) 							; primer elemento (10.punto)
		(SETQ B-ultimo (CDR (NTH (- (LENGTH BELES) 1) BELES))) 				; ultimo elemento (11.punto)
		(COMMAND "color" 5 "TEXTO" B-primer 0.2 0 "B")						; TEXTO = B
		(COMMAND "PUNTO" B-primer)									; PINTA 1 punto B
		(SETQ N-enti-B1 (ENTLAST))									; nombre ultima entidad principal 1 punto B
		(COMMAND "GRADUA" NB00 MODU)									; gradua SPLI-B
		(COMMAND "PUNTO" B-ultimo)									; PINTA Ultimo Punto B

		;	PUNTOS SECCION-B (PB1-PBn) => LIS-NB  LIS-PB  Lon-LPB													-
		(SETQ LIS-PB  nil)										; LISTA  PUNTOS-B
		(SETQ LIS-PB (CONS (CDR (ASSOC 10 (ENTGET N-enti-B1))) LIS-PB)) 			; lista entidad  -> (1 Punto-B)
		(SETQ W1B T)
		(WHILE W1B
			(SETQ N-enti-B2 (ENTNEXT N-enti-B1))						; Nombre entidad siguiente
			(COMMAND "BORRA" N-enti-B1 "")
			(IF (= N-enti-B2 nil) (SETQ W1B nil)
				(PROGN
					(SETQ LIS-PB (CONS (CDR (ASSOC 10 (ENTGET N-enti-B2))) LIS-PB))
					(SETQ N-enti-B1  N-enti-B2 )
				);progn
			);if
		) ;While W1B
		;	LISTA ( LIS-PB )																				
		(SETQ LIS-PB  (REVERSE LIS-PB))
		(SETQ NPB (LENGTH LIS-PB))

		;	SPLINE-B   DIVIDE																				
		(SETQ BLIS  (ENTGET NB00))  									; lista Spline B 
		(SETQ BELE  (ASSOC 10 BLIS))  								; 1 Punto Asociado a 10 (10.punto)
		(SETQ BELES (MEMBER BELE BLIS)) 								; lista a partir del Alterior (10.punto)....(11.punto)
		(SETQ B-primer (CDR (NTH 0 BELES))) 							; primer elemento (10.punto)
		(SETQ B-ultimo (CDR (NTH (- (LENGTH BELES) 1) BELES))) 				; ultimo elemento (11.punto)
		(COMMAND "color" 5 "TEXTO" B-primer 0.2 0 "B")						; TEXTO = B
		(COMMAND "PUNTO" B-primer)									; PINTA 1 punto B
		(SETQ N-enti-B1 (ENTLAST))									; nombre ultima entidad principal 1 punto B
		(COMMAND "DIVIDE" NB00 (- NPB 1))								; DIVIDE SPLI-B
		(COMMAND "PUNTO" B-ultimo)									; PINTA Ultimo Punto B

		;	PUNTOS SECCION-B (PB1-PBn) => LIS-NB  LIS-PB  Lon-LPB													-
		(SETQ LIS-PB  nil)										; LISTA  PUNTOS-B
		(SETQ LIS-PB (CONS (CDR (ASSOC 10 (ENTGET N-enti-B1))) LIS-PB)) 			; lista entidad  -> (1 Punto-B)
		(SETQ W1B T)
		(WHILE W1B
			(SETQ N-enti-B2 (ENTNEXT N-enti-B1))						; Nombre entidad siguiente
			;(COMMAND "BORRA" N-enti-B1 "")
			(IF (= N-enti-B2 nil) (SETQ W1B nil)
				(PROGN
					(SETQ LIS-PB (CONS (CDR (ASSOC 10 (ENTGET N-enti-B2))) LIS-PB))
					(SETQ N-enti-B1  N-enti-B2 )
				);progn
			);if
		) ;While W1B

		;	LISTA ( LIS-PB )																				
		(SETQ LIS-PB  (REVERSE LIS-PB))
		;  (LENGTH LIS-PB)

	) ; Defun SPLI-B

;																									
;-----------------------------------------------------------------------------------------------------------------------------------------------------


;-----------------------------------------------------------------------------------------------------------------------------------------------------
;	Puntos ** TRAZA ** de PLANOS de Secciones (A) y (B) => (TRAZ-1) (TRAZ-2)												

	(DEFUN TRAZA-AB ( / )

		(COMMAND "SCP" "B" NA00 )		; PLANO Sa
 			(SETQ Sa0 (TRANS (LIST    0   0 0) 1 0))
 			(SETQ Sa1 (TRANS (LIST  100 100 0) 1 0))
 			(SETQ Sa2 (TRANS (LIST -100 100 0) 1 0))
		(COMMAND "SCP" "U")

		(COMMAND "SCP" "B" NB00 )		; PLANO Sb
 			(SETQ Sa0b (TRANS Sa0 0 1))
 			(SETQ Sa1b (TRANS Sa1 0 1))
 			(SETQ Sa2b (TRANS Sa2 0 1))
 			(SETQ Sb0 (TRANS (LIST (CAR Sa0b) (CADR Sa0b) 0) 1 0))
 			(SETQ Sb1 (TRANS (LIST (CAR Sa1b) (CADR Sa1b) 0) 1 0))
 			(SETQ Sb2 (TRANS (LIST (CAR Sa2b) (CADR Sa2b) 0) 1 0))
		(COMMAND "SCP" "U")


		(SETQ TRAZ-1  (INTERS Sa0 Sa1 Sb0 Sb1 nil))
		(SETQ TRAZ-2  (INTERS Sa0 Sa2 Sb0 Sb2 nil))

		(SETQ TRAZ-12 (LIST 	(+ (CAR   TRAZ-2) (/ (- (CAR   TRAZ-1) (CAR   TRAZ-2)) 2 ))
						(+ (CADR  TRAZ-2) (/ (- (CADR  TRAZ-1) (CADR  TRAZ-2)) 2 ))
						(+ (CADDR TRAZ-2) (/ (- (CADDR TRAZ-1) (CADDR TRAZ-2)) 2 )) ) )

		;	(COMMAND "COLOR" 7 "LINEA" TRAZ-1 TRAZ-2 ""  "PUNTO" TRAZ-1)

	) ; Defun TRAZA-AB

;																									
;-----------------------------------------------------------------------------------------------------------------------------------------------------


;-----------------------------------------------------------------------------------------------------------------------------------------------------
;		PINTA CARAS en 3D y 2D																				

		(DEFUN PINTA-3D-2D ( / )

					(COMMAND "SCP" "N" "3P" 3B1 3A1 3A2)		; SCP-A

						(SETQ 2A1a (TRANS 3A1 0 1))
						(SETQ 2B1a (TRANS 3B1 0 1))
						(SETQ 2A2a (TRANS 3A2 0 1))
						(SETQ 2B2a (TRANS 3B2 0 1))

					(COMMAND "SCP" "U")

					(COMMAND "SCP" "N" "3P" 2KKB 2KKA "")		; SCP-2D

						(SETQ 2A1 (TRANS 2A1a 1 0))
						(SETQ 2B1 (TRANS 2B1a 1 0))
						(SETQ 2A2 (TRANS 2A2a 1 0))
						(SETQ 2B2 (TRANS 2B2a 1 0))

					(COMMAND "SCP" "U")

					;(COMMAND "color" 5 "3DPOL"  2A1 2B1 2B2 2A2 2A1 "" )

					(COMMAND "COLOR" 1 "LINEA" 2A1 2A2 "" )
					(COMMAND "COLOR" 8 "LINEA" 2A1 2B1 "" )
					(COMMAND "COLOR" 8 "LINEA" 2A2 2B2 "" )

					(IF (NOT (EQUAL 2B1 2B2 0.00001))
					(COMMAND "COLOR" 5 "LINEA" 2B1 2B2 "" ))

					(COMMAND "COLOR" COLO "3DCARA" 3A1 3B1 3B2 3A2 "" )

					(SETQ 2KKB 2B2 2KKA 2A2) 

		) ; defun PINTA-3D-2D

;																									
;-----------------------------------------------------------------------------------------------------------------------------------------------------




;=====================================================================================================================================================
;	*** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** 		
;=====================================================================================================================================================

(DEFUN C:PIEL-04 (/ )
  
	;	ARRANCANDO																						

	(SETVAR "blipmode" 0) (SETVAR "cmdecho" 0) (GRAPHSCR) (COMMAND "-REFENT" "DES"  "SCP" "U"  "ORTO" "DES")

	;-----------------------------------------------------------------------------------------------------------------------------------------------
	;	FIJA PARAMETROS																					
	;-----------------------------------------------------------------------------------------------------------------------------------------------


	(SETQ NCapa  (GETINT " NOMBRE de CAPA (200 ?) = ")) (TERPRI)	; N NOMBRE DE CAPA

	(SETQ MODU  0.2 )									; DISTANCIA ENTRE PUNTOS DE GRADUA (SECCION-A)

	(SETQ DIVI 4 )									; NUMERO de PUNTOS que RETROCEDE Nb (/ (LENGTH LIS-PB) DIVI )

	;-----------------------------------------------------------------------------------------------------------------------------------------------


	;																								
	;	CALCULOS																						

	(SETQ NCapa (- NCapa 1))
	(SETQ W1 T)

	(WHILE W1
		(SETQ NCapa (+ NCapa 1))
		(COMMAND "CAPA" "E" NCapa "") 					; crea y activa capa NCapa

		(SPLI-A)									; Gradua y Divide (SPLINE-A) => Puntos ( LIS-PA )
		(SPLI-B)									; Gradua y Divide (SPLINE-B) => Puntos ( LIS-PB )

		(TRAZA-AB)									; INTERSECCION PLANOS SPLINE-A SPLINE-B => (TRAZ-1) (TRAZ-2)

		;																							




		;-----------------------------------------------------------------------------------------------------------------------------------------
		;	FIJA PARAMETROS																				

		(SETQ F-LIS (/ (* (- (LENGTH LIS-PA) 1) 1.0) (* (- (LENGTH LIS-PB) 1) 1.0)) )		; FACTOR DE LISTAS A B

		(SETQ ES-H (/ 1.0 10.0))										; FACTOR ESCALA HORIZONTAL GRAFICA


		;-----------------------------------------------------------------------------------------------------------------------------------------


		;	INERSECCION TANGENTE-( PB1 PB2 ) con TRAZA-( TRAZ-1 TRAZ-2 ) => LIS-TB  (Distancias INTERSECCION a TRAZ-1)					

		(COMMAND "SCP" "3P" TRAZ-12 TRAZ-1 (NTH 0 LIS-PA) )							; PLANO TRAZ-A
			(SETQ Naa -1 )
			(SETQ LIS-TA nil)
			(REPEAT (LENGTH LIS-PA)											; *** REPEAT LIS-PA

				(SETQ Naa (+ Naa 1))
				(SETQ Paa1 (NTH (REM (+ Naa 0) (LENGTH LIS-PA)) LIS-PA))
				(SETQ Paa2 (NTH (REM (+ Naa 1) (LENGTH LIS-PA)) LIS-PA))				; PUNTO aa

				(SETQ Paa1-TR (TRANS Paa1 0 1))
				(SETQ Paa2-TR (TRANS Paa2 0 1))								; PUNTOS aa PLANO TRAZ-a

				(IF (EQUAL (CADDR Paa2-TR) 0 0.0000001)	   						; Coplanario ( Paa2 ) con ( TRAZ-1 TRAZ-2 Paa1 )
					(PROGN
						(IF (EQUAL (CADR Paa1-TR) (CADR Paa2-TR) 0.0000001)			; Paralela ( Paa1 Paa2 ) a ( TRAZ-1 TRAZ-2 )
							(SETQ DIS-T1A 100000000000000 )							; PARALELAS
							(SETQ DIS-T1A (CAR (TRANS (INTERS Paa1 Paa2  TRAZ-1 TRAZ-2 nil) 0 1)))	; SE CRUZAN
						) ; if

						(SETQ LIS-TA (CONS  DIS-T1A  LIS-TA))

					) ; progn
					(PROGN
						(PROMPT "------ (Paa1 Paa2) y (TRAZ-1 TRAZ-2) NO SON COPLANARIAS ") (TERPRI)
					) ; progn
				) ; if
			) ; repeat
		(COMMAND "SCP" "U")

		(SETQ LIS-TA (REVERSE LIS-TA))

		;	GRAFICA ( LIS-TB )  (Distancias INTERSECCION a TRAZ-1)													

			(SETQ Na -1 )
			(REPEAT (LENGTH LIS-TA)											; *** REPEAT LIS-TB

				(SETQ Na (+ Na 1))
				(SETQ DISa (NTH Na LIS-TA))									; DISTANCIAS b

				(IF (>= DISa 0)
					(SETQ PAD2y (LOG (+ DISa 1.0)))
					(SETQ PAD2y (* (LOG (+ (* DISa -1.0) 1.0)) -1.0) )
				) ; if

				(SETQ PAD2 (LIST (* Na ES-H) PAD2y))

				(IF (> Na 0) (COMMAND "COLOR" 1  "LINEA" PAD1 PAD2 "") )

				(SETQ PAD1 PAD2)

			) ; repeat

		;																							



		;	INERSECCION TANGENTE-( PB1 PB2 ) con TRAZA-( TRAZ-1 TRAZ-2 ) => LIS-TB  (Distancias INTERSECCION a TRAZ-1)					

		(COMMAND "SCP" "3P" TRAZ-12 TRAZ-1 (NTH 0 LIS-PB) )							; PLANO TRAZ-B
			(SETQ Nbb -1 )
			(SETQ LIS-TB nil)
			(REPEAT (LENGTH LIS-PB)											; *** REPEAT LIS-PB

				(SETQ Nbb (+ Nbb 1))
				(SETQ Pbb1 (NTH (REM (+ Nbb 0) (LENGTH LIS-PB)) LIS-PB))
				(SETQ Pbb2 (NTH (REM (+ Nbb 1) (LENGTH LIS-PB)) LIS-PB))				; PUNTO bb

				(SETQ Pbb1-TR (TRANS Pbb1 0 1))
				(SETQ Pbb2-TR (TRANS Pbb2 0 1))								; PUNTOS bb PLANO TRAZ-B

				(IF (EQUAL (CADDR Pbb2-TR) 0 0.0000001)	   						; Coplanario ( Pbb2 ) con ( TRAZ-1 TRAZ-2 Pbb1 )
					(PROGN
						(IF (EQUAL (CADR Pbb1-TR) (CADR Pbb2-TR) 0.0000001)			; Paralela ( Pbb1 Pbb2 ) a ( TRAZ-1 TRAZ-2 )
							(SETQ DIS-T1B 100000000000000 )							; PARALELAS
							(SETQ DIS-T1B (CAR (TRANS (INTERS Pbb1 Pbb2  TRAZ-1 TRAZ-2 nil) 0 1)))	; SE CRUZAN
						) ; if

						(SETQ LIS-TB (CONS  DIS-T1B  LIS-TB))

					) ; progn
					(PROGN
						(PROMPT "------ (Pbb1 Pbb2) y (TRAZ-1 TRAZ-2) NO SON COPLANARIAS ") (TERPRI)
					) ; progn
				) ; if
			) ; repeat
		(COMMAND "SCP" "U")

		(SETQ LIS-TB (REVERSE LIS-TB))

		;	GRAFICA ( LIS-TB )  (Distancias INTERSECCION a TRAZ-1)													

			(SETQ Nb -1 )
			(REPEAT (LENGTH LIS-TB)											; *** REPEAT LIS-TB

				(SETQ Nb (+ Nb 1))
				(SETQ DISb (NTH Nb LIS-TB))									; DISTANCIAS b

				(IF (>= DISb 0)
					(SETQ PBD2y (LOG (+ DISb 1.0)))
					(SETQ PBD2y (* (LOG (+ (* DISb -1.0) 1.0)) -1.0) )
				) ; if

				(SETQ PBD2 (LIST (* (* Nb F-LIS ) ES-H) PBD2y))

				(IF (> Nb 0) (COMMAND "COLOR" 5  "LINEA" PBD1 PBD2 "") )

				(SETQ PBD1 PBD2)

			) ; repeat

		;																							


		;	EJES GRAFICA																				



		(COMMAND "COLOR" 2 "LINEA" (LIST 0    (LOG 10000)     ) (LIST (* (- (LENGTH LIS-TA) 1) ES-H)    (LOG 10000)     ) "")
		(COMMAND "COLOR" 2 "LINEA" (LIST 0    (LOG 1000 )     ) (LIST (* (- (LENGTH LIS-TA) 1) ES-H)    (LOG 1000 )     ) "")
		(COMMAND "COLOR" 2 "LINEA" (LIST 0    (LOG 100  )     ) (LIST (* (- (LENGTH LIS-TA) 1) ES-H)    (LOG 100  )     ) "")
		(COMMAND "COLOR" 2 "LINEA" (LIST 0    (LOG 10   )     ) (LIST (* (- (LENGTH LIS-TA) 1) ES-H)    (LOG 10   )     ) "")
		(COMMAND "COLOR" 7 "LINEA" (LIST 0    (LOG 1    )     ) (LIST (* (- (LENGTH LIS-TA) 1) ES-H)    (LOG 1    )     ) "")
		(COMMAND "COLOR" 2 "LINEA" (LIST 0 (* (LOG 10   ) -1) ) (LIST (* (- (LENGTH LIS-TA) 1) ES-H) (* (LOG 10   ) -1) ) "")
		(COMMAND "COLOR" 2 "LINEA" (LIST 0 (* (LOG 100  ) -1) ) (LIST (* (- (LENGTH LIS-TA) 1) ES-H) (* (LOG 100  ) -1) ) "")
		(COMMAND "COLOR" 2 "LINEA" (LIST 0 (* (LOG 1000 ) -1) ) (LIST (* (- (LENGTH LIS-TA) 1) ES-H) (* (LOG 1000 ) -1) ) "")
		(COMMAND "COLOR" 2 "LINEA" (LIST 0 (* (LOG 10000) -1) ) (LIST (* (- (LENGTH LIS-TA) 1) ES-H) (* (LOG 10000) -1) ) "")

		(COMMAND  "TEXTO" (LIST (* (- (LENGTH LIS-TA) 1) ES-H)    (LOG 10000)     )  0.4  90 "+10.000" )
		(COMMAND  "TEXTO" (LIST (* (- (LENGTH LIS-TA) 1) ES-H)    (LOG 1000 )     )  0.4  90 "+1.000"  )
		(COMMAND  "TEXTO" (LIST (* (- (LENGTH LIS-TA) 1) ES-H)    (LOG 100  )     )  0.4  90 "+100"    )
		(COMMAND  "TEXTO" (LIST (* (- (LENGTH LIS-TA) 1) ES-H)    (LOG 10   )     )  0.4  90 "+10"     )
		(COMMAND  "TEXTO" (LIST (* (- (LENGTH LIS-TA) 1) ES-H)    (LOG 1    )     )  0.4  90 "0"       )
		(COMMAND  "TEXTO" (LIST (* (- (LENGTH LIS-TA) 1) ES-H) (* (LOG 10   ) -1) )  0.4  90 "-10"     )
		(COMMAND  "TEXTO" (LIST (* (- (LENGTH LIS-TA) 1) ES-H) (* (LOG 100  ) -1) )  0.4  90 "-100"    )
		(COMMAND  "TEXTO" (LIST (* (- (LENGTH LIS-TA) 1) ES-H) (* (LOG 1000 ) -1) )  0.4  90 "-1.000"  )
		(COMMAND  "TEXTO" (LIST (* (- (LENGTH LIS-TA) 1) ES-H) (* (LOG 10000) -1) )  0.4  90 "-10.000" )





	  




		;																							


		(SETQ 2KKB (LIST 0 0  0))
 		(SETQ 2KKA (LIST 0 -1 0))


		(TERPRI)
		(SETQ NW1 (GETSTRING "QUIERE SEGUIR (S) o N : "))
		(IF (EQUAL NW1 "N") (SETQ W1 nil) (SETQ W1 T))

	) ;CIERRE WHILE W1
  
	;																								

	;	PARANDO																						
	(SETVAR "blipmode" 1) (SETVAR "cmdecho" 1)
) ;CIERRE DEFUN PIEL-04
;=====================================================================================================================================================



